% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipality_grp.R
\name{municipality_grp_unnest}
\alias{municipality_grp_unnest}
\title{Create a municipality table from a Kolada Municipality Group metadata table}
\usage{
municipality_grp_unnest(munic_grp_df)
}
\arguments{
\item{munic_grp_df}{A Kolada Municipality Group metadata table, as created by
e.g. \code{get_municipality_groups}.}
}
\value{
A Kolada Municipality metadata table
}
\description{
Municipality groups are a convenient way to discover pre-rendered sets of
municipalities. A practical workflow for discovering
such sets can be to search through Municipality Group metadata using
\code{\link{municipality_grp_search}} to search for keywords and
\code{\link{municipality_grp_describe}} to inspect contents of KPI groups.
Once you have created a Municipality Group metadata table that has been
narrowed down to the group/s you are looking for,
\code{\link{municipality_grp_unnest}} is used to create a municipality
metadata table for further processing.
}
\examples{
if (kolada_available()) {
# Download Municipality Group metadata
# (skip the parameter "max_results" to actually download all available data)
munic_grp_df <- get_municipality_groups(max_results = 100)

# Create a Municipality metadata table from municipality groups matching the
# term "Arboga"
munic_grp_df \%>\%
  municipality_grp_search("arboga") \%>\%
  municipality_grp_unnest()
}

}
