% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.functions.R
\name{ts.uStar}
\alias{ts.uStar}
\title{Calculate physical indices for a timeseries.}
\usage{
ts.uStar(wtr, wnd, wnd.height, bathy, seasonal = TRUE)
}
\arguments{
\item{wtr}{A data frame of water temperatures (in Celsius). Loaded using
\code{\link{load.ts}}. Must have columns \code{datetime}, \code{wtr_##.#}
where ##.# is depth in meters.}

\item{wnd}{A data frame of wind speeds (in m/s). Loaded using
\code{\link{load.ts}}}

\item{wnd.height}{Height of the anemometer above the lake surface in meters}

\item{bathy}{A data frame containing hypsometric data. Loaded using
\code{\link{load.bathy}}}

\item{seasonal}{Boolean indicating if seasonal thermocline should be used in
calculation.}
}
\value{
Returns a data frame with the timeseries of calculated derivatives.
All include a \sQuote{datetime} column, but derivative columns differ
between functions.
}
\description{
Functions for simplifying the calculation of physical indices for a
timeseries of observation data.  Can usually be called directly on data
loaded directly using \code{\link{load.ts}} and \code{\link{load.bathy}}.

These are wrapper functions that accept a timeseries of data and call the
core physical metric functions (like \code{\link{schmidt.stability}}) on
each timestep.
}
\seealso{
For loading input data \code{\link{load.ts}},
\code{\link{load.bathy}}.

For the underlying functions operating at each timestep
\code{\link{meta.depths}}, \code{\link{thermo.depth}},
\code{\link{schmidt.stability}}, \code{\link{lake.number}},
\code{\link{internal.energy}}.

Other Timeseries functions for r Lake Analyzer: \code{\link{ts.internal.energy}},
  \code{\link{ts.lake.number}},
  \code{\link{ts.meta.depths}},
  \code{\link{ts.schmidt.stability}},
  \code{\link{ts.thermo.depth}}
}
\keyword{manip}
