% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose_genoprobs.R
\name{decompose_genoprobs}
\alias{decompose_genoprobs}
\title{Decomposition of conditional genotype probabilities}
\usage{
decompose_genoprobs(genoprobs, contrasts = NULL)
}
\arguments{
\item{genoprobs}{Conditional genotype probabilities as taken from \code{qtl::calc.genoprob()}.}

\item{contrasts}{A vector composed of three TRUE/FALSE values, which represents the presence/absence of specific genotypes as c(TRUE/FALSE, TRUE/FALSE, TRUE/FALSE) = AA, AB, BB.}
}
\value{
A list of three numeric matrices for genotype probabilities AA, AB, and BB. Each contains elements of individuals x markers.
\itemize{
\item{\code{AA}} {Homozygote AA probabilities.}
\item{\code{AB}} {Heterozygote AB probabilities for. NA if inbred lines}
\item{\code{BB}} {Homozygote BB probabilities. NA if backcross lines}
}
}
\description{
A function to decompose \code{qtl}'s object of conditional genotype probabilities.
}
\author{
Yasuhiro Sato (\email{sato.yasuhiro.36c@kyoto-u.jp})
}
