% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simesCT.R
\name{simesCT}
\alias{simesCT}
\title{Closed testing with Simes}
\usage{
simesCT(om1, om2, mps, m, alpha = 0.05)
}
\arguments{
\item{om1, om2}{Two omics data sets where rows are features and columns are samples.}

\item{mps, m}{Optional, pre-calculated matrix/vector of pairwise associations and the size.
To save time in calculation of parameters, a threshold such as the type I error may be applies to remove larger p-values.
If a threshold is used, size of matrix and \code{m} will not match. \code{m} should always be the size of the matrix of associations
(number of features in \code{om1}  X number of features in \code{om2}).}

\item{alpha}{type I error rate, default value is 0.05.}
}
\value{
Vector of integers: grand H value, concentration p-value, size of concentration set z,
size of the original pair-wise associations matrix and the type I error level used in calculations.
}
\description{
Calculates five parameters from closed testing with Simes local tests based on raw data.
 These parameter are unique per data/alpha-level combination and do not depend on feature sets. Calculation may
 be somewhat long depending on the size of data sets and PC configurations.
}
\examples{

#number of feature per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^6, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

}
\references{
See more details in "Hommel's procedure in linear time" doi:10.1002/bimj.201700316.
}
