% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleStep.R
\name{singleStep}
\alias{singleStep}
\title{Single step algorithm}
\usage{
singleStep(sCat, B)
}
\arguments{
\item{sCat}{p-categories matrix, output of getCat function.}

\item{B}{Optional, to identify rows to be fixed (1) or removed (0) while splitting the search space.}
}
\value{
A list of two objects, the lower bound and a heuristic for the number of true discoveries
}
\description{
Calculates heuristic and upper-bound for the number of true discoveries based on
the Algorithm 1 introduced in paper.
}
\examples{

#number of features per omic data set
n_cols<-100
n_rows<-120

#random matrix of p-values
set.seed(1258)
pvalmat<-matrix(runif(n_rows*n_cols, min=0, max=1)^5, nrow=n_rows, ncol=n_cols)

#calculate CT parameters
gCT<-simesCT(mps=pvalmat, m=nrow(pvalmat)*ncol(pvalmat))

#define the two-way feature set
subpmat<-pvalmat[61:75,81:100]

#calculate p-categories matrix for feature set by rows
rCat<-getCat(mps=subpmat, gCT, scale="row")

#get the bounds based on algorithm 1
singleStep(rCat)

#calculate p-categories matrix for feature set by columns
cCat<-getCat(mps=subpmat, gCT, scale="col")

#get the bounds based on algorithm 1 while removing column 1 and forcing column 2
singleStep(cCat, B=c(0,1))

}
\seealso{
\link{getCat}
}
