% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode_generics.R
\name{init}
\alias{init}
\alias{init<-}
\title{init}
\usage{
init(object, ...)

init(object, ...) <- value
}
\arguments{
\item{object}{a class object}

\item{...}{additional parameters}

\item{value}{a value to set}
}
\description{
Set initial values before starting the ODE solver

Set initial values before starting the ODE solver
}
\details{
Sets the tolerance like this: solver <- init(solver, dt)
Not all super classes require an init method.

Sets the tolerance like this: init(solver) <- dt
}
\examples{
# init method in Kepler.R
setMethod("init", "Kepler", function(object, initState, ...) {
    object@state <- initState
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@counter <- 0
    object
})

# init method in LogisticApp.R
setMethod("init", "Logistic", function(object, initState, r, K, ...) {
    object@r <- r
    object@K <- K
    object@state <- initState
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@counter <- 0
    object
})

# init method in Planet.R
setMethod("init", "Planet", function(object, initState, ...) {
    object@state <- object@odeSolver@ode@state <- initState
    # initialize providing the step size
    object@odeSolver <- init(object@odeSolver, getStepSize(object@odeSolver))
    object@rate <- object@odeSolver@ode@rate
    object@state <- object@odeSolver@ode@state
    object
})
}
