% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_order_multi}
\alias{rp_order_multi}
\title{Multi-Leg Live Order}
\usage{
rp_order_multi(
  accountId,
  orderType,
  orderId,
  qty,
  leg_symbols,
  leg_types,
  leg_sides,
  leg_indicator,
  leg_ratios,
  tif,
  mins = NULL,
  lmtPrc = NULL
)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{orderType}{= The Type of order: Ex. 'MARKET','LIMIT', 'STOP', 'STOP_LIMIT'}

\item{orderId}{= The order ID: use rp_getOrderId()}

\item{qty}{= leg_ratio multiple: ex. '2' multiples the leg_ratios by 2X}

\item{leg_symbols}{= Symbols: ex. c("SPY250815C00631000", "SPY250815C00631000")}

\item{leg_types}{= Symbol types: ex. c("OPTION", "OPTION")}

\item{leg_sides}{= The side for each leg: ex. c("BUY", "SELL")}

\item{leg_indicator}{= Indicates if this is BUY to OPEN/CLOSE ex. c("OPEN", "OPEN")}

\item{leg_ratios}{= The number of contracts to BUY/SELL: ex. c('5','5')}

\item{tif}{= The time in for the order: 'DAY' or 'GTD"}

\item{mins}{= Minutes till order expires.}

\item{lmtPrc}{= The limit price. Used when orderType = LIMIT or orderType = STOP_LIMIT}
}
\value{
Place a new multi-leg order and returns order id as a \code{data.frame}.
}
\description{
Multi-Leg Live Order
}
\examples{
\dontrun{
 # Fetches costs associated with the type of order being placed
 my_acc <- rp_getAccts()

 # open bull-call spread for 0.25  (buy 2, sell 2)
rp_order_multi(accountId = my_acc$accountId, orderType = "LIMIT", qty = 2,
               leg_symbols = c("SPY250815C00630000","SPY250815C00632000"),
               leg_types = c("OPTION", "OPTION"), leg_sides = c("BUY","SELL"),
               leg_indicator = c("OPEN", "OPEN"), leg_ratios = c(1, 1),
               tif = "DAY", lmtPrc = 0.25, orderId = rp_getOrderId())

 # open long butterfly for 0.05 
 rp_order_multi(accountId = my_acc$accountId, orderType = "LIMIT", qty = 1, 
                leg_symbols = c("SPY250815C00630000",
                                "SPY250815C00631000",
                                "SPY250815C00632000"), 
                leg_types = c("OPTION", "OPTION", "OPTION"), 
                leg_sides = c("BUY","SELL","BUY"), 
                leg_indicator = c("OPEN","OPEN","OPEN"), 
                leg_ratios = c(1, 2, 1), tif = "DAY", lmtPrc = 0.05, 
                orderId = rp_getOrderId())

# open iron-condor
 rp_order_multi(accountId = my_acc$accountId, orderType = "LIMIT", qty = 1, 
                leg_symbols = c("SPY250815C00631000","SPY250815C00630000",
                                "SPY250815C00625000","SPY250815C00624000"), 
                leg_types = c("OPTION", "OPTION", "OPTION","OPTION"), 
                leg_sides = c("SELL","BUY","SELL","BUY"), 
                leg_indicator = c("OPEN","OPEN","OPEN","OPEN"), 
                leg_ratios = c(1, 1, 1, 1), tif = "DAY", lmtPrc = 0.30, 
                orderId = rp_getOrderId())
                
# covered call
  rp_order_multi(accountId = my_acc$accountId, orderType = "LIMIT", qty = 1, 
                                leg_symbols = c("RIVN","RIVN250815C00012000"),
                                leg_types = c("EQUITY", "OPTION"), 
                                leg_sides = c("BUY","SELL"), 
                                leg_indicator = c("OPEN", "OPEN"), 
                                leg_ratios = c(100, 1), 
                                tif = "DAY", lmtPrc = 11.75, 
                                orderId = rp_getOrderId())

}
}
