% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{runReplicate}
\alias{runReplicate}
\title{This is the function that runs the main body, or meaningful execution, of SHAPE experiments.
In other words this is the main work-horse function that calls all the other parts and will
execute you simulation run.  It has the main parts of:
1. Stochastic Events;
2. Deaths;
3. Births;
4. Mutations;
and during mutations this is where the mutational landscape is queried and updated as required.
NOTE: Many of its internal operations are controlled by options with the suffix "shape_" and are
not explicitly passed as arguments at call to this function.}
\usage{
runReplicate(func_inputFrames, func_currStep, func_stepCounter,
  func_growthModel = getOption("shape_const_growthForm"),
  func_growthRate = getOption("shape_const_growthRate"),
  func_landscapeModel = getOption("shape_simModel"),
  func_fileName_dataBase = getOption("shape_fileName_dataBase"))
}
\arguments{
\item{func_inputFrames}{This is a list of data.frames, either 1 or 2 elements, reporting on the last
one or two steps in the simulation.}

\item{func_currStep}{This is an integer value counting the absolute step in the simulation, its value is never reset.}

\item{func_stepCounter}{This is an integer value which is a counter in the most tradititional sense.
It's job is to track if it's time for a Stochastic event to trigger and its value is reset at that point.}

\item{func_growthModel}{This is the growth model of the SHAPE run, it is passed here as a computational
convenience since it is used numerous times in the function}

\item{func_growthRate}{This is the growth rate of the SHAPE run, it is passed here as a computational
convenience since it is used numerous times in the function}

\item{func_landscapeModel}{This is the fitness landscape model of the SHAPE run, it is passed here as a computational
convenience since it is used numerous times in the function}

\item{func_fileName_dataBase}{This is the filepaths of DBs of the SHAPE run, it is passed here as a computational
convenience since it is used numerous times in the function}
}
\value{
Returns a new list of 2 data.frames reporting on the state of SHAPE community for the last 2 time steps -
ie: the one just run, and the most prior step.
}
\description{
This is the function that runs the main body, or meaningful execution, of SHAPE experiments.
In other words this is the main work-horse function that calls all the other parts and will
execute you simulation run.  It has the main parts of:
1. Stochastic Events;
2. Deaths;
3. Births;
4. Mutations;
and during mutations this is where the mutational landscape is queried and updated as required.
NOTE: Many of its internal operations are controlled by options with the suffix "shape_" and are
not explicitly passed as arguments at call to this function.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

