% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.functions.R
\name{folded.matern.covariance.2d}
\alias{folded.matern.covariance.2d}
\title{The 2d folded Matern covariance function}
\usage{
folded.matern.covariance.2d(
  h,
  m,
  kappa,
  nu,
  sigma,
  L = 1,
  N = 10,
  boundary = c("neumann", "dirichlet", "periodic", "R2")
)
}
\arguments{
\item{h, m}{Vectors with two coordinates.}

\item{kappa}{Range parameter.}

\item{nu}{Shape parameter.}

\item{sigma}{Standard deviation.}

\item{L}{The upper bound of the square \eqn{[0,L]\times [0,L]}.
By default, \code{L=1}.}

\item{N}{The truncation parameter.}

\item{boundary}{The boundary condition. The possible conditions
are \code{"neumann"} (default), \code{"dirichlet"},
\code{"periodic"} or \code{"R2"}.}
}
\value{
The correspoding covariance.
}
\description{
\code{folded.matern.covariance.2d} evaluates the 2d
folded Matern covariance function over an interval
\eqn{[0,L]\times [0,L]}.
}
\details{
\code{folded.matern.covariance.2d} evaluates the 1d folded
Matern covariance function over an interval
\eqn{[0,L]\times [0,L]} under different boundary conditions.
For periodic boundary conditions
\deqn{C_{\mathcal{P}}((h_1,h_2),(m_1,m_2)) =
\sum_{k_2=-\infty}^\infty \sum_{k_1=-\infty}^{\infty}
(C(\|(h_1-m_1+2k_1L,h_2-m_2+2k_2L)\|),}
for Neumann boundary conditions
\deqn{C_{\mathcal{N}}((h_1,h_2),(m_1,m_2)) =
\sum_{k_2=-\infty}^\infty \sum_{k_1=-\infty}^{\infty}
(C(\|(h_1-m_1+2k_1L,h_2-m_2+2k_2L)\|)+C(\|(h_1-m_1+2k_1L,
h_2+m_2+2k_2L)\|)+C(\|(h_1+m_1+2k_1L,h_2-m_2+2k_2L)\|)+
C(\|(h_1+m_1+2k_1L,h_2+m_2+2k_2L)\|)),}
and for Dirichlet boundary conditions:
\deqn{C_{\mathcal{D}}((h_1,h_2),(m_1,m_2)) = \sum_{k_2=-\infty}^\infty
\sum_{k_1=-\infty}^{\infty} (C(\|(h_1-m_1+2k_1L,h_2-m_2+2k_2L)\|)-
C(\|(h_1-m_1+2k_1L,h_2+m_2+2k_2L)\|)-C(\|(h_1+m_1+2k_1L,
h_2-m_2+2k_2L)\|)+C(\|(h_1+m_1+2k_1L,h_2+m_2+2k_2L)\|)),}
where \eqn{C(\cdot)} is the Matern covariance function:
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}
(\kappa h)^\nu K_\nu(\kappa h).}

We consider the truncation for \eqn{k_1,k_2} from \eqn{-N} to \eqn{N}.
}
\examples{
h <- c(0.5, 0.5)
m <- c(0.5, 0.5)
folded.matern.covariance.2d(h, m, kappa = 10, nu = 1 / 5, sigma = 1)

}
