% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime.R
\name{precision.spacetimeobj}
\alias{precision.spacetimeobj}
\title{Get the precision matrix of spacetimeobj objects}
\usage{
\method{precision}{spacetimeobj}(object, kappa = NULL, sigma = NULL, gamma = NULL, rho = NULL, ...)
}
\arguments{
\item{object}{The model object computed using \code{\link[=spacetime.operators]{spacetime.operators()}}}

\item{kappa}{If non-null, update the range parameter of
the covariance function.}

\item{sigma}{If non-null, update the standard deviation of
the covariance function.}

\item{gamma}{If non-null, update the temporal range parameter
of the covariance function.}

\item{rho}{If non-null, update the drift parameter of the
covariance function.}

\item{...}{Currently not used.}
}
\value{
The precision matrix.
}
\description{
Function to get the precision matrix of a spacetimeobj object
}
\examples{
s <- seq(from = 0, to = 20, length.out = 101)
t <- seq(from = 0, to = 20, length.out = 31)

op_cov <- spacetime.operators(space_loc = s, time_loc = t,
                             kappa = 5, sigma = 10, alpha = 1,
                             beta = 2, rho = 1, gamma = 0.05)
prec_matrix <- precision(op_cov)
}
\seealso{
\code{\link[=simulate.spacetimeobj]{simulate.spacetimeobj()}}, \code{\link[=spacetime.operators]{spacetime.operators()}}
}
