% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{flow_through_line}
\alias{flow_through_line}
\title{Calculate the total flow passing through a line}
\usage{
flow_through_line(
  aem,
  x0,
  y0,
  x1,
  y1,
  flow = c("discharge", "darcy"),
  split = FALSE,
  ...
)
}
\arguments{
\item{aem}{\code{aem} object}

\item{x0}{numeric, starting x location of line.}

\item{y0}{numeric, starting y location of line.}

\item{x1}{numeric, ending x location of line.}

\item{y1}{numeric, ending y location of line.}

\item{flow}{character specifying which flow variable to use. Possible values are \code{discharge} (default) and \code{darcy}. See \code{\link[=flow]{flow()}}.}

\item{split}{logical, should the flow be split up into positive and negative flows (\code{TRUE}) or should they be summed (\code{FALSE}; default)? See details.}

\item{...}{ignored}
}
\value{
If \code{split = FALSE}, a single value with the total flow of variable \code{flow} passing through the line at a right angle.
If \code{split = TRUE} a named vector with the total positive and total negative value of \code{flow} passing through the line.
}
\description{
\code{\link[=flow_through_line]{flow_through_line()}} computes the integrated flow passing through a straight line at a right angle.
}
\details{
The flow is computed normal to the line and integrated along the line length using \code{\link[stats:integrate]{stats::integrate()}}.
The flow value is positive going to the left when looking in the direction of the line (i.e. to the left going from \code{x0-y0}
to \code{x1-y1}).

If \code{split = FALSE} (the default), a single value is returned which is the sum of the positive and negative flows perpendicular to the line.
If \code{split = TRUE}, both the positive and negative component of the total flow through the line are returned.

If the line corresponds to a line element, the integration might fail. Try to perturbate the line vertices slightly in that case.
}
\examples{
rf <- constant(-1000, 0, hc = 10)
uf <- uniformflow(TR = 100, gradient = 0.001, angle = -45)
m <- aem(k = 10, top = 10, base = 0, n = 0.2, rf, uf)

xg <- seq(-500, 500, l=100); yg <- seq(-300, 300, l=100)
contours(m, xg, yg, col='dodgerblue', nlevels=20)

x0 <- -200
y0 <- -50
x1 <- 300
y1 <- 100
lines(matrix(c(x0, y0, x1, y1), ncol = 2, byrow = TRUE))

flow_through_line(m, x0, y0, x1, y1)
flow_through_line(m, x1, y1, x0, y0) # reverse direction of line

w <- well(125, 200, 150)
m <- aem(k = 10, top = 10, base = 0, n = 0.2, rf, uf, w)
contours(m, xg, yg, col='dodgerblue', nlevels=20)
lines(matrix(c(x0, y0, x1, y1), ncol = 2, byrow = TRUE))

flow_through_line(m, x0, y0, x1, y1, flow = 'darcy')
flow_through_line(m, x0, y0, x1, y1, flow = 'darcy', split = TRUE)

}
\seealso{
\code{\link[=flow]{flow()}}, \code{\link[=dirflow]{dirflow()}}
}
