% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/well.R
\name{well}
\alias{well}
\title{Create an analytic element of a constant-discharge well}
\usage{
well(xw, yw, Q, rw = 0.3, ...)
}
\arguments{
\item{xw}{numeric, x location of the well.}

\item{yw}{numeric, y location of the well.}

\item{Q}{numeric, volumetric discharge of the well (positive is out of aquifer).}

\item{rw}{numeric, radius of well. Defaults to 0.3 length units.}

\item{...}{ignored}
}
\value{
Analytic element of a well with constant discharge which is an object of class \code{well} and inherits from \code{element}.
}
\description{
\code{\link[=well]{well()}} creates an analytic element of a well with constant discharge.
}
\details{
The inner annulus of a well element constitutes a singularity in the equations as the hydraulic head is undefined at
a distance smaller than \code{rw} from the well center. If a state- or flow-variable is calculated within this annulus, its
location is reset to its nearest location on the well screen.

The well is assumed to fully penetrate the saturated aquifer.
}
\examples{
w <- well(xw = 50, yw = 0, Q = 200, rw = 0.3)

}
\seealso{
\code{\link[=headwell]{headwell()}}
}
