% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experts.R
\name{Experts}
\alias{Experts}
\alias{makeExpert}
\alias{makeStepwiseExpert}
\alias{makeScavengerExpert}
\title{Making Expert Objects}
\usage{
makeExpert(bidder, constructor)

makeStepwiseExpert(gWealth, ncolumns)

makeScavengerExpert(gWealth, theModelFeatures, name)
}
\arguments{
\item{bidder}{bidder object; output of makeStepwiseBidder.}

\item{constructor}{constructor object; output of makeRawSource or
makeLocalScavenger.}

\item{gWealth}{global wealth object, output of gWealthStep.}

\item{ncolumns}{number of features the constructor should manage, thought of
as columns of the design matrix.}

\item{theModelFeatures}{list of feature names in the model when the feature
was rejected.}

\item{name}{name of base feature used in interactions with other features in
the model.}
}
\value{
A closure containing a list of functions.
}
\description{
Experts are the "actors" which "bid" to see who conducts the
  next test. They contain an object "bidder" that determines bidding strategy
  and an object "constructor" that determines which feature it wants to text
  next. The \code{\link{runAuction}} function calls functions from experts
  and gWealth. The makeExpert function is not called directly, but through
  makeStepwiseExpert or makeScavengerExpert. Defaults are not set because
  these are internal functions called by \code{\link{rai}} and
  \code{\link{runAuction}} and all arguments are required.
}
