% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_readJudgePresenterMatrix.R
\name{readJudgePresenterMatrix}
\alias{readJudgePresenterMatrix}
\title{Transform a Judge-Presenter Matrix Converter}
\usage{
readJudgePresenterMatrix(jpMat)
}
\arguments{
\item{jpMat}{a Judge-Presenter matrix, or a User-Movie matrix}
}
\value{
A list, including numGame 
\enumerate{
 \item \code{numGame}: Number of times teams i and j faced eath other
 \item \code{numWin}: Number of wins teams i plays against j 
 \item \code{numTie}: Number of ties teams i plays against j 
 \item \code{numLoss}: Number of losses teams i plays against j 
 \item \code{numPt}: Number of points teams i accumulates against j 
}
}
\description{
Convert a judge-presenter matrix to a set of square matrices
}
\examples{
jpMat <- matrix(data=c(5,4,3,0, 5,5,3,1, 0,0,0,5, 0,0,2,0, 4,0,0,3, 1,0,0,4),
nrow=6,byrow=TRUE)
result <- readJudgePresenterMatrix(jpMat)
print(result)
}
\author{
Jiangtao Gou

Shuyi Wu
}
