% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_records.R
\name{insert_records}
\alias{insert_records}
\title{Insert records into an Airtable table}
\usage{
insert_records(
  data,
  airtable,
  typecast = FALSE,
  parallel = FALSE,
  batch_size = 10
)
}
\arguments{
\item{data}{A dataframe containing records to insert}

\item{airtable}{An airtable object}

\item{typecast}{If \code{TRUE}, values will be converted to match the base if possible. Set to \code{TRUE} to add new values to a multi select field.}

\item{parallel}{If \code{TRUE}, use parallel processing for encoding large tables}

\item{batch_size}{Number of records per request to insert. Maximum of 10}
}
\value{
A dataframe (invisibly) of the input data, to be stored as an object or piped into further `dplyr` functions
}
\description{
Insert rows into an Airtable table. Requires that data names and types exactly match column names and types in Airtable. Violating this assumption will return a 422 Unprocessable Entity error. Supports batch insert and parallel JSON encoding (recommended for large tables).
}
