% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limit.R
\name{limit}
\alias{limit}
\title{Limit range of values in a \code{SpatRaster} object}
\usage{
limit(x, y = NULL, min = NULL, max = NULL)
}
\arguments{
\item{x}{Object to limit, a \code{SpatRaster}-class object.}

\item{y}{Either a range (i.e. a \code{numeric} vector with two values), or \code{data.frame} with positioned color values (column \code{z} indicates values), or a calibrated ramp (e.g. produced with \code{expand}).}

\item{min}{If \code{y} is not given, the minimum value to have in the \code{data.frame}.}

\item{max}{If \code{y} is not given, the maximum value to have in the \code{data.frame}.}
}
\value{
A \code{SpatRaster} object.
}
\description{
Shorthand for limiting maximum and minimum values in a \code{SpatRaster}-class object.
}
\examples{
# This function relies on the terra extension
if(requireNamespace("terra", quietly=TRUE)){
 library(terra)
	# Example 1. Using specific values
	# a SpatRaster object
	r<- terra::rast()
	# populate with a Gaussian distribution
	terra::values(r) <- rnorm(terra::ncell(r), 0.5,1 )
	# and limit
	rLimit <- limit(r, min=-0.2, max=0.2)
	plot(rLimit)


	# Example 2. Using an expanded color ramp
	# Create a data.frame
	df <- data.frame(
		z=c(-1, -0.2, 0, 0.2, 1),
		color=rev(gradinv(5))
	)
	ramp <- expand(df, n=200)
	rLimited <- limit(r, y=ramp)
	# default
	plot(rLimited)

	# manual ramping.
	plot(rLimited, breaks=ramp$breaks, col=ramp$col,
		legend=FALSE)

	# temporary solution for manual legend
	# Marginal ramps will be implemented later
	ramplegend(x=140, y=90, ramp=ramp, cex=0.5,
		at=c(-1, 0, 1), label=c("< -1", 0, "> +1"))


}
}
