% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_cauchy}
\alias{r_cauchy}
\title{Generate Cauchy Distributed Values}
\usage{
r_cauchy(
  location = 0,
  scale = 1,
  ...,
  n = default_n(location, scale),
  .seed = NULL
)
}
\arguments{
\item{location}{vector of locations}

\item{scale}{vector of scales, strictly positive}

\item{...}{Unused}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Cauchy distributed values.
}
\examples{

set_n(5)

r_cauchy(10)

r_cauchy(1:10)

r_cauchy(10, 2)

r_cauchy(10, 2, n = 10)
}
