% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_nbinom}
\alias{r_nbinom}
\title{Generate Negative Binomial Distributed Values}
\usage{
r_nbinom(
  r = NULL,
  prob = 0.5,
  ...,
  mu = NULL,
  n = default_n(r, prob, mu),
  .seed = NULL
)
}
\arguments{
\item{r}{number of failure trials until stopping, strictly positive}

\item{prob}{vector of probabilities of success on each trial, between 0 & 1}

\item{...}{Unused}

\item{mu}{vector of means}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Negative Binomial distributed values. Only two of \code{r},
\code{prob} and \code{mu} can be provided.
}
\note{
It is important to note that this is the number of \emph{failures},
and not the number of \emph{successes}, as in \code{rnbinom()}, so
\code{rnbinom(prob = x,...)} is equivalent to \code{r_nbinom(prob=1-x,...)}
}
\examples{

set_n(5)

r_nbinom(10, 0.5)

r_nbinom(1:10, mu = 2)
#'
r_nbinom(10, 0.2, n = 10)
}
