% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSD-Bias.R
\name{GSD_allocation_seq}
\alias{GSD_allocation_seq}
\title{Calculates the Type I error for a randomization sequence in a group sequential design}
\usage{
GSD_allocation_seq(sfu, K, seq, ui = "No")
}
\arguments{
\item{sfu}{Group sequential design used (currently available: \code{"Pocock"} - Pocock, \code{"OF"} - O'Brien & Fleming,
\code{sfLDPocock} - Lan & DeMets with Pocock like alpha spending function,
\code{sfLDOF} - Lan & DeMets with O'Brien & Fleming like alpha spending function)}

\item{K}{number of stages}

\item{seq}{List of consecutive treatment allocations. 1 for first treatment A, 2 for second treatment.}

\item{ui}{Only for Lan & DeMets design. Update critical values after each stage according to allocation ratio observed if set to \code{"yes"}.}
}
\value{
A list of type I error probabilities for each stage.
}
\description{
Calculates the Type I error for a randomization sequence in a group sequential design
}
\examples{
#Simulate a group sequential design according to Pocock's design with 24 patients
#and the following consecutive treatment allocation:
#A, A, B, A, A, B, A, B, A, B, A, B, A, B, A, B, B, B, A, B, B, A, B, B
GSD_allocation_seq(sfu ="Pocock", K=3, seq = c(1,1,0,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,0))
#Simulate a group sequential design according to Lan and DeMets with O'Brien & Fleming
#like alpha spending with 24 patients and the following consecutive treatment allocation:
#A, A, B, A, A, B, A, B, A, B, A, B, A, B, A, B, B, B, A, B, B, A, B, B
library(gsDesign)
GSD_allocation_seq(sfu =sfLDOF, K=3, seq = c(1,1,0,1,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,0))
}
