% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmb.R
\name{rmb}
\alias{rmb}
\title{Random Mallows-Binomial generation}
\usage{
rmb(I, p, theta, M, pi0 = NULL, R = NULL)
}
\arguments{
\item{I}{A numeric entry indicating the number of observations to be drawn, i.e., the number of judges
providing rankings and ratings.}

\item{p}{A vector specifying the underlying object qualities. All values between be between 0 and 1, inclusive.}

\item{theta}{A numeric entry specifying the Mallows scale parameter.}

\item{M}{A numeric entry specifying the maximum integer rating.}

\item{pi0}{A vector specifying the consensus (modal probability) ranking; should be used only for tie-breaking
equal values in \code{p}.}

\item{R}{A numeric entry specifying the length of the rankings to be drawn. When \code{R<=length(p)}, partial
rankings are drawn by definition.}
}
\value{
A list containing elements \code{ratings}, a matrix of integer ratings with one row per judge
and one column per object, \code{rankings}, and matrix of rankings (orderings) with one row per judge,
and \code{M}, the inputted maximum integer rating.
}
\description{
This function randomly generates rankings and ratings from a Mallows-Binomial distribution.
}
\examples{
rmb(I=5,p=c(.1,.3,.4,.7,.9),theta=1,M=10)
rmb(I=10,p=c(.1,.3,.3,.7,.9),pi0=c(1,3,2,4,5),theta=5,M=40,R=3)

}
