% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePosterior.R
\name{mergePosterior}
\alias{mergePosterior}
\title{Merge posterior distributions}
\usage{
mergePosterior(...)
}
\arguments{
\item{...}{any number of posterior distributions as produced by the function 'readMCMC'.}
}
\value{
A merged posterior distribution in the same format.
}
\description{
Join two or more independent MCMC chains from the same data and phylogenetic trees by appending them together into a single chain.
}
\examples{
\donttest{
data( centrarchidae )
## Run multiple MCMC chains.
handle.list <- lapply(1:4, function(x) ratematrixMCMC(data=centrarchidae$data
                      , phy=centrarchidae$phy.map, gen=10000, dir=tempdir()) )
## Read all to a list
posterior.list <- lapply(handle.list, readMCMC)
## Merge all posteriors in the list.
merged.four <- mergePosterior(posterior.list)
## Merge some of the posteriors.
merged.two <- mergePosterior(posterior.list[[1]], posterior.list[[3]])
}
}
\author{
Daniel S. Caetano and Luke J. Harmon
}
