% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showRatioOfQspraysX1X2X3}
\alias{showRatioOfQspraysX1X2X3}
\title{Print a 'ratioOfQsprays'}
\usage{
showRatioOfQspraysX1X2X3(var, quotientBar = "  \%//\%  ", ...)
}
\arguments{
\item{var}{a string, usually a letter, to denote the non-indexed variables}

\item{quotientBar}{a string representing the quotient bar between the
numerator and the denominator, including surrounding spaces,
e.g \code{" / "}}

\item{...}{arguments other than \code{quotientBar} passed to
\code{\link{showRatioOfQsprays}}}
}
\value{
A function which takes as argument a \code{ratioOfQsprays} object
  and which prints it.
}
\description{
Print a \code{ratioOfQsprays} object given a string to denote
  the non-indexed variables.
}
\note{
The function returned by this function can be used as the option
  \code{"showRatioOfQsprays"} of the setter function
  \code{\link{showRatioOfQspraysOption<-}}. If you do not use the
  ellipsis arguments, this is equivalent to set the \code{"x"}
  option and the \code{"quotientBar"} option (see example).
}
\examples{
set.seed(666)
( roq <- rRatioOfQsprays() )
showRatioOfQspraysX1X2X3("X", " / ")(roq)
# setting a show option:
showRatioOfQspraysOption(roq, "showRatioOfQsprays") <-
  showRatioOfQspraysX1X2X3("X", " / ")
roq
# this is equivalent to set the "x" and "quotientBar" options:
showRatioOfQspraysOption(roq, "x") <- "X"
showRatioOfQspraysOption(roq, "quotientBar") <- " / "
}
\seealso{
\code{\link{showRatioOfQspraysXYZ}},
  \code{\link{showRatioOfQspraysOption<-}}.
}
