% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dataset.R
\name{generate_dataset}
\alias{generate_dataset}
\title{Generate Dataset}
\usage{
generate_dataset(..., output_every = 1)
}
\arguments{
\item{...}{arguments to be passed to \code{\link{sample.libbi}}, especially
'model', 'end_time' and 'seed'.}

\item{output_every}{real; if given, \code{noutputs} will be set so that there
is output every \code{output_every} time steps; if set to 0, only generate
an output at the final time}
}
\value{
a \code{libbi} object, the generated data set
}
\description{
This is a wrapper around \code{libbi sample --target joint
  --nsamples 1}, to generate a synthetic dataset from a model. Parameters can
  be passed via the 'init' option (see \code{\link{run.libbi}}, otherwise
  they are generated from the prior specified in the model. The end time
  should be specified using the "end_time" option. If this is not given, only
  a parameter set is sampled. Use the 'noutputs' or 'output_every' options to
  control the number of data points being generated. By default, output_every
  is set to 1.
}
