% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{advertisement}
\alias{advertisement}
\title{Data on Political Advertisement and Campaign Contributions in US Presidential Elections}
\format{
A data frame with 16,265 rows and 15 columns: \describe{
  \item{zip}{zip code}
  \item{treat}{the log transformed TotAds}
  \item{TotAds}{the total number of political advertisements aired in the zip code}
  \item{TotalPop}{population size}
  \item{PercentOver65}{percent of the population over 65}
  \item{Inc}{median household income}
  \item{PercentHispanic}{percent Hispanic}
  \item{PercentBlack}{percent black}
  \item{density}{population density (people per sq mile)}
  \item{per_collegegrads}{percent college graduates}
  \item{CanCommute}{a dummy variable indicating whether it is possible to commute to the zip code from a competitive state}
  \item{StFIPS}{state FIPS code}
  \item{Cont}{campaign contributions (in thousands of dollars)}
  \item{log_TotalPop}{log population}
  \item{log_Inc}{log median income}
  }
}
\usage{
advertisement
}
\description{
A dataset containing 15 variables on the campaign contributions of 16,265 zip codes to the
2004 and 2008 US presidential elections in addition to the demographic characteristics of each area
(Urban and Niebler 2014; Fong, Hazlett, and Imai 2018).
}
\references{
Fong, Christian, Chad Hazlett, and Kosuke Imai. 2018. Covariate Balancing Propensity Score for a Continuous
  Treatment: Application to The Efficacy of Political Advertisements. The Annals of Applied Statistics 12(1):156-77.

Urban, Carly, and Sarah Niebler. 2014. Dollars on the Sidewalk: Should U.S. Presidential Candidates Advertise in Uncontested States?
  American Journal of Political Science 58(2):322-36.
}
\keyword{datasets}
