#' Print method for Functions
#'
#' @param x Functions, an object class generated by
#' \code{\link{function_from_edge}} or \code{function_from_user} functions.
#' @param ... Additional arguments are ignored in this method, but are included
#' to maintain consistency with the generic print method.
#'
#' @return A summary of vertices that has functions. If there are vertices
#' without functions, an instruction is shown.
#'
#' @keywords function
#'
#' @export
#'
#' @importFrom magrittr %>%
#'
#' @examples
#'
#' data(edges)
#' functions <- function_from_edge(edges)
#' print(functions)

print.Functions=function(x, ...){
  n=length(x)

  x_func=
    x[sapply(x,is.function)]

  cat(length(x_func),'/',n,' vertices have functions.\n')
  if(length(x_func)<n){
    x_no_func=
      x[!sapply(x,is.function)]

    x_no_func_msg=
      paste0(
        names(x_no_func)
        ,' = function('
        ,x_no_func %>%
          sapply(paste0,collapse=',')
        ,')'
      ) %>%
      paste0(collapse='\n')

    cat('Please define functions for:\n')
    cat(x_no_func_msg)
  }
}
