% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{rconfig}
\alias{rconfig}
\alias{value}
\alias{value.default}
\alias{command}
\alias{command.default}
\title{Manage R Configuration at the Command Line}
\usage{
rconfig(
  file = NULL,
  list = NULL,
  eval = NULL,
  flatten = NULL,
  debug = NULL,
  sep = NULL,
  sub = NULL,
  ...
)

value(x, ...)

\method{value}{default}(x, default = NULL, coerce = TRUE, ...)

command(x, ...)

\method{command}{default}(x, ...)
}
\arguments{
\item{file}{Configuration file name or URL (\code{NULL} to not use
this configuration file to override the default behavior).
Can be a vector, in which case each element will be treated
as a configuration file, and these will be parsed and applied
in the order they appear.}

\item{list}{A list to override other configs (\code{NULL} to not use
this list to override the default behavior). This argument is treated
as a single configuration (as opposed to \code{file}). List names need
to be unique.}

\item{eval}{Logical, evaluate \code{!expr} R expressions.}

\item{flatten}{Logical, should config contain nested lists or should
results be flat, i.e. \code{a$b$c} to flattened into the key \code{a.b.c};
like \code{\link[=unlist]{unlist()}} but returning a list and preserving the value types.}

\item{debug}{Logical, when debug mode is on the configuration
source information are attached as the \code{"trace"} attribute.}

\item{sep}{Character, separator for text files.}

\item{sub}{Logical, substitute environment variables (see Details).}

\item{...}{Other arguments passed to file parsers:
\code{\link[yaml:yaml.load]{yaml::yaml.load_file()}} for YAML,
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} for JSON, and
\code{\link[utils:read.table]{utils::read.table()}} for text files.}

\item{x}{A list, e.g. the \code{rconfig()} output.}

\item{default}{A default value to be used when a configuration
entry is not set.}

\item{coerce}{Logical, should values of \code{x} coerced to the same
type as \verb{storage.mode(default).}}
}
\value{
The configuration value (a named list, or an empty list).
When debug mode is on, the \code{"trace"} attribute traces the
merged configurations. The \code{value()} method returns the value
of a given argument or the default value when it is not found
(i.e. \code{NULL}). The \code{command()} method returns a character vector
with command line sub-commands (can be of length 0).
}
\description{
Manage R configuration using files (YAML, JSON, INI, TXT)
JSON strings and command line arguments. Command line arguments
can be used to provide commands and to override configuration.
Period-separated command line flags are parsed as hierarchical
lists.
}
\details{
Merges configuration after parsing files, JSON strings,
and command line arguments. Note that rconfig only considers
trailing command line arguments from Rscript.
rconfig differentiates verb/noun syntax, where
verbs are sub-commands following the R script file name
and preceding the command line flags (starting with \code{-} or \verb{--}).
Configurations are merged in the following order
(key-values from last element override previous values for the same key):
\enumerate{
\item \code{R_RCONFIG_FILE} value or \code{"rconfig.yml"} from working directory
\item JSON strings (following \code{-j} and \code{--json} flags)
and files (following \code{-f} and \code{--file} flags)
provided as command line arguments are parsed and applied
in the order they appear (key-value pairs are separated by space,
only atomic values considered, i.e. file name or string)
for each flag, but multiple file/JSON flags are accepted in sequence
\item the remaining other command line arguments, that can be
sub-commands or command line flags
(starting with \code{-} or \verb{--}), period-separated
command line flags are parsed as hierarchical lists
(key-value pairs are separated by space, flags must begin
with \verb{--}, values are treated as vectors when contain spaces,
i.e. \verb{--key 1 2 3})
\item configuration from the \code{file} argument (one or multiple files,
parsed and applied in the order they appear)
\item configuration from the \code{list} argument
}

The following environment variables and options can be set to
modify the default behavior:
\itemize{
\item \code{R_RCONFIG_FILE}: location of the default configuration file,
it is assumed to be \code{rconfig.yml} in the current working directory.
The file name can be an URL or it can can be missing.
\item \code{R_RCONFIG_EVAL}: coerced to logical, indicating whether
R expressions starting with \code{!expr} should be evaluated in the
namespace environment for the base package
(overrides the value of \code{getOption("rconfig.eval")}).
When not set the value assumed is \code{TRUE}.
\item \code{R_RCONFIG_SUB}: coerced to logical, indicating whether
environment variables should be substituted
(overrides the value of \code{getOption("rconfig.sub")}).
When not set the value assumed is \code{TRUE}.
\item \code{R_RCONFIG_FLATTEN}: coerced to logical, flatten nested lists,
i.e. \code{a$b$c} becomes the key \code{a.b.c}
(overrides the value of \code{getOption("rconfig.flatten")}).
When not set the value assumed is \code{FALSE}.
\item \code{R_RCONFIG_DEBUG}: coerced to logical, to turn on debug mode
(overrides the value of \code{getOption("rconfig.debug")}).
When not set the value assumed is \code{FALSE}.
\item \code{R_RCONFIG_SEP}: separator for text file parser,
(overrides the value of \code{getOption("rconfig.sep")}).
When not set the value assumed is \code{"="}.
}

When the configuration is a file (file name can also be a URL),
it can be nested structure in JSON or YAML format.
Other text files are parsed using the
separator (\code{R_RCONFIG_SEP} or \code{getOption("rconfig.sep")}) and
period-separated keys are parsed as hierarchical lists
(i.e. \code{a.b.c=12} is treated as \code{a$b$c = 12}) by default.

When the configuration is a file or a JSON string,
values starting with \code{!expr} will be evaluated depending on the
settings \code{R_RCONFIG_EVAL} and \code{getOption("rconfig.eval")}.
E.g. \verb{cores: !expr getOption("mc.cores")}, etc.

The rconfig package interprets 3 kinds of substitution patterns:
\itemize{
\item environment variables (\verb{$\{VALUE\}}): these variables are already present when the configurations is read from the calling environment or from \code{.Renviron} file in the project specific or home folder, set variables can be null or not-null
\item R global variables (\verb{@\{VALUE\}}): the rconfig package looks for variables in the global environment at the time of configuration evaluation, however, expressions are not evaluated (unlike the \code{!expr} option for values)
\item configuration values (\verb{#\{VALUE\}}): the configuration level variables are evaluated last, thus these values can refer to existing keys that are already substituted
}

For additional details see the package website at
\href{https://github.com/analythium/rconfig}{https://github.com/analythium/rconfig}.
}
\examples{
cfile <- function(file) {
    system.file("examples", file, package = "rconfig")
}

rconfig::rconfig()

rconfig::rconfig(
    file = cfile("rconfig.yml"))

rconfig::rconfig(
    file = c(cfile("rconfig.json"),
             cfile("rconfig-prod.txt")),
    list = list(user = list(name = "Jack")))

rconfig::rconfig(
    file = c(cfile("rconfig.json"),
             cfile("rconfig-prod.txt")),
    list = list(user = list(name = "Jack")),
    flatten = TRUE)

CONFIG <- rconfig::rconfig(
    file = cfile("rconfig.yml"))
value(CONFIG$cores, 2L)   # set to 1L
value(CONFIG$test, FALSE) # unset

}
\seealso{
\code{\link[utils:modifyList]{utils::modifyList()}}
}
