# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Run a k-means clustering analysis, returning a list of cluster assignments
#'
#' This function performs a k-means clustering analysis on the given data set.
#'
#' @title Run a k-means clustering analysis
#' @param data A matrix of data values
#' @param clusters An integer specifying the number of clusters
#' @return A list with cluster assignments
#' @examples
#' x <- rbind(matrix(rnorm(100, sd = 0.3), ncol = 2),
#'            matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2))
#' colnames(x) <- c("x", "y")
#' cl <- kMeans(x, 2)
#'
#' data(trees, package="datasets")
#' cl2 <- kMeans(t(trees),3)
kMeans <- function(data, clusters) {
    .Call(`_rcppmlpackexamples_kMeans`, data, clusters)
}

#' Run a linear regression (with optional ridge regression)
#'
#' This function performs a linear regression, and serves as a simple
#' test case for accessing an MLPACK function.
#'
#' @title Run a linear regression with optional ridge regression
#' @param matX A matrix of explanatory variables (\sQuote{predictors}) in standard
#' R format (i.e. \sQuote{tall and skinny} to be transposed internally to MLPACK
#' format (i.e. \sQuote{short and wide}).
#' @param vecY A vector of dependent variables (\sQuote{responses})
#' @param lambda An optional ridge parameter, defaults to zero
#' @param intercept An optional boolean switch about an intercept, default is true.
#' @return A vector with fitted values
#' @examples
#' suppressMessages(library(utils))
#' data("trees", package="datasets")
#' X <- with(trees, cbind(log(Girth), log(Height)))
#' y <- with(trees, log(Volume))
#' lmfit <- lm(y ~ X)
#' # summary(fitted(lmfit))
#' mlfit <- linearRegression(X, y)
#' # summary(mlfit)
#' all.equal(unname(fitted(lmfit)),  as.vector(mlfit))
linearRegression <- function(matX, vecY, lambda = 0.0, intercept = TRUE) {
    .Call(`_rcppmlpackexamples_linearRegression`, matX, vecY, lambda, intercept)
}

#' Predict loan default using a decision tree model
#'
#' This functions performs a loan default prediction based on three variables
#' on employment, bank balance and annual salary to predict loan repayment or
#' default
#'
#' @title loanDefaultPrediction
#' @param loanDataFeatures A matrix of dimension 3 by N, i.e. transposed relative to
#' what R uses, with the three explanantory variables
#' @param loanDataTargets A vector of (integer-valued) binary variables loan repayment
#' or default
#' @param pct A numeric variable with the percentage of data to be used for testing,
#' defaults to 25\%
#' @return A list object with predictions, probabilities, accuracy and a report matrix
#' @examples
#' data(loanData)
#' res <- loanDefaultPrediction(t(as.matrix(loanData[,-4])),  # col 1 to 3, transposed
#'                              loanData[, 4],                # col 4 is the target
#'                              0.25)                         # retain 25% for testing
#' str(res)
#' res$report
loanDefaultPrediction <- function(loanDataFeatures, loanDataTargets, pct = 0.25) {
    .Call(`_rcppmlpackexamples_loanDefaultPrediction`, loanDataFeatures, loanDataTargets, pct)
}

#' Run a Random Forest Classifier
#'
#' This function performs a Random Forest classification on a subset of the
#' standard \sQuote{covertype} data set
#'
#' @title Run a Random Forest classificatio
#' @param dataset A matrix of explanatory variables, i.e. \dQuote{features}
#' @param labels A vector of the dependent variable as integer values, i.e. \dQuote{labels}
#' @param pct A numeric value for the percentage of data to be retained for the test set
#' @param nclasses An integer value for the number of a distinct values in \code{labels}
#' @param ntrees An integer value for the number of trees
#' @return A list object
#' @seealso covertype_small
#' @examples
#' data(covertype_small)                         # see help(covertype_small)
#' res <- randomForest(covertype_small[-55,],    # features (already transposed)
#'                     covertype_small[55,],     # labels now in [0, 6] range
#'                     0.3)                      # percentage used for testing
#' str(res)  # accuracy varies as method is randomized but not seed set here
randomForest <- function(dataset, labels, pct = 0.3, nclasses = 7L, ntrees = 10L) {
    .Call(`_rcppmlpackexamples_randomForest`, dataset, labels, pct, nclasses, ntrees)
}

