% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{guardian_and}
\alias{guardian_and}
\alias{guardian_operators}
\alias{guardian_or}
\title{AND and OR operators for Guardian filters and queries.}
\usage{
guardian_and(...)

guardian_or(...)
}
\arguments{
\item{...}{a vector of terms (or several vector of terms)}
}
\value{
a single string containing the terms, separated by the AND (,) or
OR (|) separators used by the Guardian API.
}
\description{
\code{guardian_and} and \code{guardian_or} provide
(respectively) the AND and OR logical operators. If you pass them your
query terms, it passes them back either separated (so that the Guardian API
knows to consider a match to any \emph{one} term a match) or grouped (so that
the API only matches if every term appears).
}
\examples{
# Simple AND example
guardian_and("sausage", "mash")

# With ORs
guardian_or("sausage", "mash")
}

