% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax2dist.R
\name{tax2dist}
\alias{tax2dist}
\title{Generate taxonomic distance matrix}
\usage{
tax2dist(lookup, tax_distance, precompute_dist = TRUE)
}
\arguments{
\item{lookup}{\code{data.frame} with colnames corresponding to nested
taxonomic levels, e.g. c('Species', 'Genus', 'Family', 'Subclass')}

\item{tax_distance}{\code{vector} with the distances attributed to
taxonomic levels defined in \code{lookup}. The highest distance is the
distance attributed to species that are not the same at any recorded
taxonomic level. e.g. c(Species = 0, Genus = 1, Family = 2, Subclass = 3,
Other = 4) from Shimatani.}

\item{precompute_dist}{object of class \code{logical} or \code{numeric}.
When TRUE (by default) a distance matrix is generated and stored in slot
\code{distance}, when FALSE no distance matrix is generated, and when numeric
a distance matrix is generated until the number of species exceeds the
defined value.}
}
\value{
\code{tax2dist()} returns an object of class \code{distance}
containing a \code{matrix} of pairwise taxonomic distances
}
\description{
Calculates taxonomic distances between species.
}
\examples{
# Create Lookup table
Species <- c("tenuifolium", "asterolepis", "simplex var.grandiflora", "simplex var.ochnacea")
Genus <- c("Protium", "Quararibea", "Swartzia", "Swartzia")
Family <- c("Burseraceae", "Bombacaceae", "Fabaceae", "Fabaceae")
Subclass <- c("Sapindales", "Malvales", "Fabales", "Fabales")
lookup <- cbind.data.frame(Species, Genus, Family, Subclass)

# Assign values for each level (Shimatani's taxonomic distance)
tax_distance <- c(Species = 0, Genus = 1, Family = 2, Subclass = 3, Other = 4)

# Generate pairwise distances
distance <- tax2dist(lookup, tax_distance)
similarity <- dist2sim(distance, "linear")

}
\references{
Shimatani, K. 2001. On the measurement of species diversity
incorporating species differences. Oikos 93:135–147.
}
