% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdryad-package.R
\docType{package}
\name{rdryad-package}
\alias{rdryad-package}
\alias{rdryad}
\title{Interface to the Dryad Web services}
\description{
Includes access to Dryad's Solr API, OAI-PMH service, and part of
their REST API.
}
\section{Package API}{


The functions match the three major sets of Dryad API routes for
datasets, fiiles and versions.

Datasets:
\itemize{
\item \code{\link[=dryad_dataset]{dryad_dataset()}}
\item \code{\link[=dryad_datasets]{dryad_datasets()}}
\item \code{\link[=dryad_dataset_versions]{dryad_dataset_versions()}}
}

Files:
\itemize{
\item \code{\link[=dryad_files]{dryad_files()}}
\item \code{\link[=dryad_files_download]{dryad_files_download()}}
}

Versions:
\itemize{
\item \code{\link[=dryad_versions]{dryad_versions()}}
\item \code{\link[=dryad_versions_files]{dryad_versions_files()}}
\item \code{\link[=dryad_versions_download]{dryad_versions_download()}}
}
}

\section{Defunct}{


The Dryad Solr API is no longer being updated, so the functions
that used to work with it are all defunct, see \link{solr-defunct}

The Dryad OAI-PMH service is no longer being updated, so the functions
that used to work with it are all defunct, see \link{oai-defunct}

More defunct functions:
\itemize{
\item \code{\link[=dryad_metadata]{dryad_metadata()}}
\item \code{\link[=dryad_package_dois]{dryad_package_dois()}}
\item \code{\link[=handle2doi]{handle2doi()}}
\item \code{\link[=doi2handle]{doi2handle()}}
\item \code{\link[=dryad_files]{dryad_files()}}
\item \code{\link[=dryad_fetch]{dryad_fetch()}} - use instead \code{\link[=dryad_files_download]{dryad_files_download()}} or
\code{\link[=dryad_versions_download]{dryad_versions_download()}}
}
}

