% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_bars_gradient.R
\name{data_bars_gradient}
\alias{data_bars_gradient}
\title{Add horizontal gradient bars to rows in a column}
\usage{
data_bars_gradient(
  data,
  colors = c("#1efffd", "#1e20ff"),
  background = "white",
  number_fmt = NULL
)
}
\arguments{
\item{data}{Dataset containing at least one numeric column.}

\item{colors}{A vector of colors of at least two colors.
Colors should be given in order from left to right as shown on the data bar.
Default colors are c("#1efffd", "#1e20ff").}

\item{background}{Optionally assign a color to use as the background for cells.
Default is set to white.}

\item{number_fmt}{Optionally format numbers using formats from the scales package.
Default is set to NULL.}
}
\value{
a function that applies data bars
    to a column of numeric values.
}
\description{
The `data_bars_gradient()` function is depreciated.
    The new version of `data_bars()` can convert colors into gradients with `gradient = TRUE`.
    Please use `data_bars()` instead.
}
\examples{
data <- MASS::Cars93[20:49, c("Make", "MPG.city", "MPG.highway")]

## By default, colors are provided
reactable(data,
defaultColDef = colDef(
align = "left",
cell = data_bars(data,
fill_color = c("#1efffd", "#1e20ff"),
fill_gradient = TRUE)))

}
