% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{fivethirtyeight}
\alias{fivethirtyeight}
\title{Theme fivethirtyeight}
\usage{
fivethirtyeight(
  font_size = 14,
  font_color = "#222222",
  header_font_size = 12,
  header_font_color = "#000000",
  cell_padding = 5,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #222222.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 12.}

\item{header_font_color}{Color of the font for the header text.
Default is #000000.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 5.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
538-inspired table theme
}
\examples{
data <- iris[10:29, ]

## Standard fivethirtyeight theme
reactable(data,
          theme = fivethirtyeight())

## Additional options applied
reactable(data,
          theme = fivethirtyeight(font_size = 12, font_color = "grey", cell_padding = 3))

}
