% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{no_lines}
\alias{no_lines}
\title{Theme no_lines}
\usage{
no_lines(
  font_size = 14,
  font_color = "#222222",
  header_font_size = 15,
  header_font_color = "#222222",
  centered = FALSE,
  cell_padding = 6
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 14.}

\item{font_color}{Color of the font for the text within the table.
Default is #222222.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 15.}

\item{header_font_color}{Color of the font for the header text.
Default is transparent}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 6.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
A table style with no lines or borders
}
\examples{
data <- iris[10:29, ]

## Standard no_lines theme
reactable(data,
          theme = no_lines())

## Additional options applied
reactable(data,
          theme = no_lines(font_size = 12, font_color = "grey", cell_padding = 3))

}
