% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_stan_function.R
\name{create_stan_function}
\alias{create_stan_function}
\title{Create a Stan's ODE function from an XMILE file}
\usage{
create_stan_function(
  filepath,
  func_name,
  pars = NULL,
  override.consts = NULL,
  additional_funs = NULL
)
}
\arguments{
\item{filepath}{A string that indicates a path to a file with extension .stmx
or .xmile. Vensim files (.mdl) are not xmile files. They must be exported
from Vensim with extension .xmile}

\item{func_name}{A string for naming the ODE function}

\item{pars}{A character vector that indicates which constants will be
considered as parameters in the ODE function}

\item{override.consts}{A list in which each element is a name-value pair that
replaces values of constants.}

\item{additional_funs}{A vector of strings. Each string corresponds to a
user-defined function.}
}
\value{
A string with the code containing the model's equations in the
 format required by Stan.
}
\description{
\code{create_stan_function} returns a string with the code for a Stan's ODE function
}
\details{
This function extracts the xml from the file specified via \code{filepath} to
generate the code for an equivalent model in Stan.
}
\examples{
path <- system.file("models", "SIR.stmx", package = "readsdr")
create_stan_function(path, "my_model")
}
