% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulators.R
\name{sd_sensitivity_run}
\alias{sd_sensitivity_run}
\title{Perform a sensitivity run on a System Dynamics model}
\usage{
sd_sensitivity_run(
  ds_inputs,
  consts_df = NULL,
  stocks_df = NULL,
  start_time = NULL,
  stop_time = NULL,
  timestep = NULL,
  integ_method = "euler",
  multicore = FALSE,
  n_cores = NULL,
  reporting_interval = 1
)
}
\arguments{
\item{ds_inputs}{A list of deSolve inputs generated by read_xmile}

\item{consts_df}{A data frame that contains the values of constants to
simulate. Each column corresponds to a constant and each row to an
iteration. If \code{stocks_df} is also supplied, both data frames must have
the same number of rows.}

\item{stocks_df}{A data frame that containts the initial value of stocks to
be explored. Each column corresponds to a stock and each row to an
iteration. If \code{consts_df} is also supplied, both data frames must have
the same number of rows.}

\item{start_time}{A number indicating the time at which the simulation begins.}

\item{stop_time}{A number indicating the time at which the simulation ends.}

\item{timestep}{A number indicating the time interval for the simulation.
Also known as \code{dt}.}

\item{integ_method}{A string indicating the integration method. It can be
either "euler" or "rk4"}

\item{multicore}{A boolean value that indicates whether the process
is parallelised.}

\item{n_cores}{An integer indicating the number of cores for the parallel run.}

\item{reporting_interval}{A real number indicating the interval at which the
simulation results are returned. The default is set to \code{1}. For
instance, if the simulation runs from 0 to 10. This function returns the
results at times 0, 1, 2, ..., 10.}
}
\value{
A data frame
}
\description{
\code{sd_sensitivity_run} returns a data frame with the simulation of a
model for several iterations of different inputs.
}
\examples{
path      <- system.file("models", "SIR.stmx", package = "readsdr")
ds_inputs <- xmile_to_deSolve(path)
consts_df <- data.frame(i = c(0.25, 0.30))
sd_sensitivity_run(ds_inputs, consts_df)
}
