% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{find_mec}
\alias{find_mec}
\title{Find the Maximum Observed Effluent Concentration (MEC)}
\usage{
find_mec(qual, result, nd = c("<", "nd", "ND"), simple_output = FALSE)
}
\arguments{
\item{qual}{A character vector containing non-detect indicator strings, e.g., "<" or "ND". The strings used to indicate censored status can be edited in the "nd" argument.}

\item{result}{A numeric vector of concentration measurements.}

\item{nd}{A list indicating all the censoring flags included in the dataset. Defaults to "<", "nd", and "ND".}

\item{simple_output}{Logical value. If TRUE, the output columns are concatenated into a single character string (e.g., "<0.2") which can be useful for constructing summary tables.}
}
\value{
Dataframe with a qualifier column (character) and a MEC column (numeric).
}
\description{
Find the MEC (no projection) from the observed dataset using methods described in EPA's Technical Support Document for Water Quality-based Toxics Control.
}
\examples{
# Find observed MEC
cen_result <- c(rep("", 10), rep("<", 10))
result     <- 1:20
find_mec(cen_result, result)

cen_result <- rep("<", 20)
find_mec(cen_result, result)

cen_result <- rep("", 20)
find_mec(cen_result, result)

# Demonstrate simplified output
find_mec(cen_result, result, simple_output = TRUE)

# Define a set of custom non-detect flags
cen_result <- c(rep("non-detect", 5), rep("<", 10), rep("mdl", 5))
find_mec(cen_result, result, nd = c("non-detect", "<", "mdl"))

}
