% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{handle_bibliography}
\alias{handle_bibliography}
\title{function to solve bibliography problems}
\usage{
handle_bibliography(article_dir, override_mode = FALSE, log_rebib = FALSE)
}
\arguments{
\item{article_dir}{path to the directory which contains tex article}

\item{override_mode}{force use parser and ignore BibTeX bibliography.}

\item{log_rebib}{option to enable log files for rebib}
}
\value{
bibliography links the bibtex file with latex source code or
generates a minimal bibtex file from embedded bibliography and links that
file to the latex file
}
\description{
if bibliography exists in bibtex format then (filename.bib) bibtex file will
be preferred.
else this function will generate a minimal bibliography
}
\examples{
dir.create(your_article_folder <- file.path(tempdir(), "exampledir"))
example_files <-  system.file("article", package = "rebib")
x <- file.copy(from = example_files,to=your_article_folder,recursive = TRUE)
your_article_path <- paste(your_article_folder,"article",sep="/")
rebib::handle_bibliography(your_article_path)
unlink(your_article_folder,recursive = TRUE)
}
