#' Formatul TSV a unui (sub)set de lecții repartizate pe zile 
#'
#' Vizualizează lecțiile distribuite în fiecare zi unui grup de profesori.
#'
#' @param D Distribuția pe zile a unor lecții în "format lung" 
#'     (prof | cls |zl); de exemplu, a lecțiilor unei clase, discipline, etc.
#'
#' @return Setul liniilor (numite după profesori) conținând pe fiecare zi,
#'     clasele repartizate profesorilor pentru ziua respectivă
#' @export
#'
tidy2tsv <- function(D) {
    D <- D %>% mutate(prof = factor(.data$prof)) %>% arrange(.data$prof)
    Dz <- split(D, ~ zl)
    Z <- map(Zile, function(z) {
             map_dfr(split(Dz[[z]], ~ prof), function(L)
                  data.frame(prof = L$prof[1],
                             cls = paste(L$cls, collapse=" "))
             )
         }) %>% setNames(Zile)
    data.frame(prof = levels(D$prof), 
               Lu = Z$Lu$cls, Ma = Z$Ma$cls, Mi = Z$Mi$cls, 
               Jo = Z$Jo$cls, Vi = Z$Vi$cls)
}


