% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{posdec}
\alias{posdec}
\title{Multiple point position decision in relation to a set of stacked surfaces (3D)}
\usage{
posdec(crdf, maplist)
}
\arguments{
\item{crdf}{data.frame with the spatial coordinates of the points of interest. Must contain three
columns with the x axis values, y axis values and z axis values of the points in the order x, y, z}

\item{maplist}{list of data.frames which contain the points that make up the surfaces. The individual
data.frames must have the same structure as \code{crdf}}
}
\value{
data.frame with the spatial coordinates of the points of interest and the respective position
information
}
\description{
\code{posdec} has the purpose to make a decision about the position of individual points in relation
to a set of stacked surfaces in 3D space. The decision is made by comparing the mean z axis value of
the four horizontally closest points of a surface to the z axis value of the point in question.
}
\examples{
df1 <- data.frame(
  x = rnorm(50),
  y = rnorm(50),
  z = rnorm(50) - 5
)

df2 <- data.frame(
  x = rnorm(50),
  y = rnorm(50),
  z = rnorm(50) + 5
)

lpoints <- list(df1, df2)

maps <- kriglist(lpoints, lags = 3, model = "spherical")

finds <- data.frame(
  x = c(0, 1, 0.5, 0.7),
  y = c(0.5, 0, 1, 0.7),
  z = c(-10, 10, 0, 2)
)

posdec(finds, maps)

}
\seealso{
Other posdecfuncs: \code{\link{posdeclist}}
}
