% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_problink_em.R
\name{predict.problink_em}
\alias{predict.problink_em}
\title{Calculate weights and probabilities for pairs}
\usage{
\method{predict}{problink_em}(
  object,
  pairs = newdata,
  newdata = NULL,
  type = c("weights", "mpost", "probs", "all"),
  binary = FALSE,
  add = FALSE,
  comparators,
  inplace = FALSE,
  new_name = NULL,
  ...
)
}
\arguments{
\item{object}{an object of type \code{problink_em} as produced by 
\code{\link{problink_em}}.}

\item{pairs}{a object with pairs for which to calculate weights.}

\item{newdata}{an alternative name for the \code{pairs} argument. Specify 
\code{newdata} or \code{pairs}.}

\item{type}{a character vector of length one specifying what to calculate. 
See results for more information.}

\item{binary}{convert comparison vectors to binary vectors using the 
comparison function in comparators.}

\item{add}{add the predictions to the original pairs object.}

\item{comparators}{a list of comparison functions (see \code{\link{compare_pairs}}). 
When missing \code{attr(pairs, 'comparators')} is used.}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}

\item{new_name}{name of new object to assign the pairs to on the cluster
nodes (only relevant when pairs is of type \code{cluster_pairs}.}

\item{...}{unused.}
}
\value{
When \code{pairs} is of type \code{pairs}, returns a data.table with either
the \code{.x} and \code{.y} columns from  \code{pairs} (when \code{add = FALSE}) 
or all columns of \code{pairs}. To these columns are added: 

\itemize{
\item In case of \code{type = "weights"} a column \code{weights} with the calculated
  weights.
\item In case of \code{type = "mpost"} a column \code{mpost} with the calculated
  posterior probabilities (probability that pair is a match given comparison vector.
\item In case of \code{type = "prob"} the columns \code{mprob} and \code{uprob} with the
  m and u-probabilites and \code{mpost} and \code{upost} with the posterior m- and
  u-probabilities.
\item In case of \code{type = "all"} all of the above.
}

In case of \code{compare_pairs.cluster_pairs}, \code{compare_pair.pairs} is called on
each cluster node and the resulting pairs are assigned to \code{new_name} in
the environment \code{reclin_env}. When \code{new_name} is not given (or
equal to NULL) the original pairs on the nodes are overwritten.
}
\description{
Calculate weights and probabilities for pairs
}
