% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_population_trends.R
\name{rl_population_trends}
\alias{rl_population_trends}
\title{IUCN Red List population trends}
\usage{
rl_population_trends(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character or Numeric. One or more population trend codes (\code{0}-\code{3}).
Use \code{\link[=rl_population_trends]{rl_population_trends()}} to list available trend codes and definition.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available population trend categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified trend(s), including population trend description,
population trend code, year, latest, and other relevant metadata.
}
\description{
Retrieve available population trend categories or species assessments for one
or more trends.
}
\details{
This function has two modes:
\itemize{
\item If \code{code = NULL}, it returns a list of available population trend categories.
\item If \code{code} is provided, it retrieves assessments for the specified trend(s),
optionally filtered by year, extinction status, scope, and page(s).
}

Population trends include: Increasing, Decreasing, Stable, or Unknown.

If \code{page} is not specified, the function will automatically paginate over all
available pages for each parameter combination.
}
\examples{
\dontrun{
# List all available population trend categories
rl_population_trends()

# Retrieve assessments for species with decreasing populations
rl_population_trends(code = "1")

# Get latest decreasing population assessments from 2020
rl_population_trends(
  code = 2,
  year_published = 2020,
  latest = TRUE
)
}
}
