% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redis_tools.R
\name{redis_time}
\alias{redis_time}
\alias{format_redis_time}
\alias{redis_time_to_r}
\title{Get time from Redis}
\usage{
redis_time(con)

format_redis_time(x)

redis_time_to_r(x)
}
\arguments{
\item{con}{A Redis connection object}

\item{x}{a list as returned by \code{TIME}}
}
\description{
Get time from Redis and format as a string.
}
\examples{
\dontshow{if (redux::redis_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
r <- redux::hiredis()

# The output of Redis' TIME command is not the *most* useful
# thing in the world:
r$TIME()

# We can get a slightly nicer representation like so:
redux::redis_time(r)

# And from that convert to an actual R time:
redux::redis_time_to_r(redux::redis_time(r))
\dontshow{\}) # examplesIf}
}
