% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QS-class.R
\name{qs}
\alias{qs}
\title{Quota Share Treaty: User constructor function}
\usage{
qs(csn_clm, csn_prm = "auto", com = 0, ptf = "all")
}
\arguments{
\item{csn_clm}{Numeric. Cession rate on claims. Should be between 0 and 1.}

\item{csn_prm}{Numeric. Cession rate on premiums. Should be between 0 and 1. Default value set to \code{csn_clm}.}

\item{com}{Numeric. Commission rate, applied on the part of premiums given to the reinsurer. Should be between 0 and 1. Default value set to 0.}

\item{ptf}{Vector. List of portfolios on which the treaty is to be applied on. Default value set to all.}
}
\value{
An object of class \code{QS} (\code{\link{QS-class}}), initialized with the values given in input. Its basic methods are:
\itemize{
 \item{\code{show}}
}
}
\description{
\code{qs} defines an object of class \code{QS} (\code{\link{QS-class}}).
}
\examples{
treaty_1 <- qs(0.8, com = 0.25)
treaty_1

}
