% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locusIBS.R
\name{locusIBS}
\alias{locusIBS}
\title{Identity by state at a locus}
\usage{
locusIBS(profMat)
}
\arguments{
\item{profMat}{A matrix consisting of 4 columns and N rows. Each row in the
matrix consists of the genotypes of two individuals.}
}
\value{
A vector of length N containing values 0, 1, or 2 depending on how
many alleles each pair of profiles share at a locus.
}
\description{
Calculates the number of alleles that are shared by two profiles at a single
locus.  If the two profiles in question are indeed relatives then the
matching alleles may be identical by descent, or by random chance alone,
hence identity by state.
}
\examples{

data(fbiCaucs)
G = randomSample(1, fbiCaucs, rel = 'FS', N = 1000)
ibs = locusIBS(G)
barplot(tabulate(ibs+1, nbins = 3))

}
\author{
James M. Curran
}
