% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makef.R
\name{makef}
\alias{makef}
\title{Make non-linear features}
\usage{
makef(x, r, df, tol = 0.01, removeLin = T)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is
an observation vector.}

\item{r}{Vector of residuals.}

\item{df}{Degrees of freedom for the fit.}

\item{tol}{A tolerance for same-ness or uniqueness of the x values. To be
passed to the \code{smooth.spline()} function. Default is \code{0.01}.}

\item{removeLin}{If \code{TRUE} (default), removes the linear component from
the newly created non-linear features.}
}
\value{
A list:
\item{f}{Non-linear features associated with the features in \code{x}.}
\item{spline_fit}{A list of the spline fits of the residual against each
feature. Useful for creating the non-linear features for new data.}
\item{lin_comp_fit}{If \code{removeLin = TRUE}, a list of coefficients for
simple linear regression of non-linear feature on original feature. Useful
for creating the non-linear features for new data.}
}
\description{
Internal function for making non-linear features.
}
