% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-methods.R
\name{lemmy_get_posts}
\alias{lemmy_get_posts}
\title{Get / fetch posts, with various filters.}
\usage{
lemmy_get_posts(
  type_ = NULL,
  sort = NULL,
  page = NULL,
  limit = NULL,
  community_id = NULL,
  community_name = NULL,
  saved_only = NULL,
  auth = NULL,
  .lemmy_instance = getOption("lemmy_instance", "https://lemmy.world")
)
}
\arguments{
\item{type_}{(Optional) One of "All", "Local", or "Subscribed".}

\item{sort}{(Optional) One of "Active", "Hot", "New", "Old", "TopDay", "TopWeek", "TopMonth", "TopYear", "TopAll", "MostComments", "NewComments", "TopHour", "TopSixHour", "TopTwelveHour", "TopThreeMonths", "TopSixMonths", or "TopNineMonths".}

\item{page}{(Optional) A numeric value.}

\item{limit}{(Optional) A numeric value.}

\item{community_id}{(Optional) A numeric value.}

\item{community_name}{(Optional) A character value.}

\item{saved_only}{(Optional) A logical value.}

\item{auth}{(Optional) A character value.}

\item{.lemmy_instance}{Default: "https://lemmy.world". Change the default instance by setting the \code{lemmy_instance} \code{\link[=options]{options()}}.}
}
\value{
A \code{list} of length 1:
\preformatted{<list>
`-posts: <list>
  `-[Each element]: <list>
    |-post: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-url: (Optional) A character value
    | |-body: (Optional) A character value
    | |-creator_id: A numeric value
    | |-community_id: A numeric value
    | |-removed: A logical value
    | |-locked: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-nsfw: A logical value
    | |-embed_title: (Optional) A character value
    | |-embed_description: (Optional) A character value
    | |-thumbnail_url: (Optional) A character value
    | |-ap_id: A character value
    | |-local: A logical value
    | |-embed_video_url: (Optional) A character value
    | |-language_id: A numeric value
    | |-featured_community: A logical value
    | `-featured_local: A logical value
    |-creator: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-display_name: (Optional) A character value
    | |-avatar: (Optional) A character value
    | |-banned: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-actor_id: A character value
    | |-bio: (Optional) A character value
    | |-local: A logical value
    | |-banner: (Optional) A character value
    | |-deleted: A logical value
    | |-inbox_url: A character value
    | |-matrix_user_id: (Optional) A character value
    | |-admin: A logical value
    | |-bot_account: A logical value
    | |-ban_expires: (Optional) A character value
    | `-instance_id: A numeric value
    |-community: <list>
    | |-id: A numeric value
    | |-name: A character value
    | |-title: A character value
    | |-description: (Optional) A character value
    | |-removed: A logical value
    | |-published: A character value
    | |-updated: (Optional) A character value
    | |-deleted: A logical value
    | |-nsfw: A logical value
    | |-actor_id: A character value
    | |-local: A logical value
    | |-icon: (Optional) A character value
    | |-banner: (Optional) A character value
    | |-followers_url: A character value
    | |-inbox_url: A character value
    | |-hidden: A logical value
    | |-posting_restricted_to_mods: A logical value
    | `-instance_id: A numeric value
    |-creator_banned_from_community: A logical value
    |-counts: <list>
    | |-id: A numeric value
    | |-post_id: A numeric value
    | |-comments: A numeric value
    | |-score: A numeric value
    | |-upvotes: A numeric value
    | |-downvotes: A numeric value
    | |-published: A character value
    | |-newest_comment_time_necro: A character value
    | |-newest_comment_time: A character value
    | |-featured_community: A logical value
    | |-featured_local: A logical value
    | |-hot_rank: A numeric value
    | `-hot_rank_active: A numeric value
    |-subscribed: One of "Subscribed", "NotSubscri...
    |-saved: A logical value
    |-read: A logical value
    |-creator_blocked: A logical value
    |-my_vote: (Optional) A numeric value
    `-unread_comments: A numeric value
}
}
\description{
\code{HTTP.GET /post/list}
}
\examples{
\dontshow{if (remmy:::is_lemmy_world()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
post_list <- lemmy_get_posts(community_name = "showerthoughts", sort = "TopAll", limit = 1)

post_list$posts[[1]]$post$name
\dontshow{\}) # examplesIf}
}
