% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot,EotMode,ANY-method}
\alias{plot,EotStack,ANY-method}
\title{Plot an Eot* object}
\usage{
\S4method{plot}{EotMode,ANY}(
  x,
  y,
  pred.prm = "rsq",
  resp.prm = "r",
  show.bp = FALSE,
  anomalies = TRUE,
  add.map = TRUE,
  ts.vec = NULL,
  arrange = c("wide", "long"),
  clr = NULL,
  locations = FALSE,
  ...
)

\S4method{plot}{EotStack,ANY}(
  x,
  y,
  pred.prm = "rsq",
  resp.prm = "r",
  show.bp = FALSE,
  anomalies = TRUE,
  add.map = TRUE,
  ts.vec = NULL,
  arrange = c("wide", "long"),
  clr = NULL,
  locations = FALSE,
  ...
)
}
\arguments{
\item{x}{either an object of EotMode or EotStack as returned by \code{\link[=eot]{eot()}}}

\item{y}{integer or character of the mode to be plotted (e.g. 2 or "mode_2")}

\item{pred.prm}{the parameter of the predictor to be plotted.\cr
Can be any of "r", "rsq", "rsq.sums", "p", "int" or "slp"}

\item{resp.prm}{the parameter of the response to be plotted.\cr
Can be any of "r", "rsq", "rsq.sums", "p", "int" or "slp"}

\item{show.bp}{logical. If \code{TRUE} a grey circle will be drawn
in the predictor image to indicate the location of the base point}

\item{anomalies}{logical. If \code{TRUE} a reference line will be drawn
a 0 in the EOT time series}

\item{add.map}{logical. If \code{TRUE} country outlines will be added
to the predictor and response images}

\item{ts.vec}{an (optional) time series vector of the considered
EOT calculation to be shown as the x-axis in the time series plot}

\item{arrange}{whether the final plot should be arranged in "wide" or
"long" format}

\item{clr}{an (optional) color palette for displaying of the
predictor and response fields}

\item{locations}{logical. If x is an EotStack, set this to TRUE to
produce a map showing the locations of all modes. Ignored if x is an
EotMode}

\item{...}{further arguments to be passed to \code{\link[raster:spplot]{raster::spplot()}}}
}
\description{
This is the standard plotting routine for the results of \code{\link[=eot]{eot()}}.
Three panels will be drawn i) the predictor domain, ii) the response
domain, iii) the time series at the identified base point
}
\section{Methods (by class)}{
\itemize{
\item \code{plot(x = EotStack, y = ANY)}: EotStack

}}
\examples{
data(vdendool)

## claculate 2 leading modes
nh_modes <- eot(x = vdendool, y = NULL, n = 2, 
                standardised = FALSE, 
                verbose = TRUE)

## default settings 
plot(nh_modes, y = 1) # is equivalent to

\dontrun{
plot(nh_modes[[1]]) 

plot(nh_modes, y = 2) # shows variance explained by mode 2 only
plot(nh_modes[[2]]) # shows cumulative variance explained by modes 1 & 2

## showing the loction of the mode
plot(nh_modes, y = 1, show.bp = TRUE)

## changing parameters
plot(nh_modes, y = 1, show.bp = TRUE,
     pred.prm = "r", resp.prm = "p")
        
## change plot arrangement
plot(nh_modes, y = 1, show.bp = TRUE, arrange = "long") 

## plot locations of all base points
plot(nh_modes, locations = TRUE)
}

}
