% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reservoir.R
\name{createNode}
\alias{createNode}
\title{Function to create some node}
\usage{
createNode(
  nodeType = c("Ridge"),
  units = NULL,
  lr = 1,
  sr = NULL,
  otputDim = NULL,
  inputDim = NULL,
  name = NULL,
  ridge = 0,
  inputBias = TRUE,
  input_scaling = TRUE,
  input_connectivity = 0.1,
  rc_connectivity = 0.1,
  activation = "tanh",
  dtype = "float64",
  seed = NULL,
  ...
)
}
\arguments{
\item{nodeType}{Type of node. Default is \code{"Ridge"}.}

\item{units}{(int) optional 
Number of reservoir units. If None, the number of units will be infered from
the \code{W} matrix shape.}

\item{lr}{(float) default to 1.0
Neurons leak rate. Must be in :math:\code{[0, 1]}.}

\item{sr}{(float) optional
Spectral radius of recurrent weight matrix.}

\item{otputDim}{Output dimension of the Node. Dimension of its state.}

\item{inputDim}{Input dimension of the Node.}

\item{name}{Name of the Node. It must be a unique identifier.}

\item{ridge}{float, default to \code{0.0}. L2 regularization parameter.}

\item{inputBias}{bool, default to \code{TRUE}. If \code{TRUE}, then a bias parameter 
will be learned along with output weights.}

\item{input_scaling}{float or array-like of shapes (features), default to \code{1.0}.
Input gain. An array of the same dimension as the inputs can be used to
set up different input scaling for each feature.}

\item{input_connectivity}{float, default to 0.1. Connectivity of input neurons, i.e. ratio of input neurons connected to reservoir neurons. Must be between 0 and 1.}

\item{rc_connectivity}{float, default to 0.1. Connectivity of recurrent weight matrix, i.e. ratio of reservoir neurons connected to other reservoir neurons, including themselves. Must be between 0 and 1.}

\item{activation}{str 'tanh'. Reservoir units activation function. Should be a activationsfunc function name ('tanh', 'identity', 'sigmoid', 'relu', 'softmax', 'softplus').}

\item{dtype}{Numerical type for node parameters}

\item{seed}{set random seed}

\item{...}{Others params}
}
\value{
A node generated by reservoirpy python module.
}
\description{
Function to create some node
}
\examples{
if(interactive()){
readout <- reservoirnet::createNode("Ridge")
}

}
