% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lie-group.R
\name{MatrixLieGroup}
\alias{MatrixLieGroup}
\title{Abstract Class for Matrix Lie Groups}
\description{
Class for matrix Lie groups.
}
\examples{

## ------------------------------------------------
## Method `MatrixLieGroup$exp`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  # so3$exp(diag(1, 3)) # TO DO: fix in gs
}

## ------------------------------------------------
## Method `MatrixLieGroup$log`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$log(diag(1, 3))
}

## ------------------------------------------------
## Method `MatrixLieGroup$get_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$get_identity()
}

## ------------------------------------------------
## Method `MatrixLieGroup$lie_bracket`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$lie_bracket(diag(0, 3), diag(1, 3))
}

## ------------------------------------------------
## Method `MatrixLieGroup$tangent_translation_map`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  tangent_map <- so3$tangent_translation_map(diag(1, 3))
  tangent_map(diag(1, 3))
}

## ------------------------------------------------
## Method `MatrixLieGroup$compose`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$compose(diag(1, 3), diag(1, 3))
}

## ------------------------------------------------
## Method `MatrixLieGroup$inverse`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$inverse(diag(1, 3))
}
}
\author{
Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{MatrixLieGroup}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lie_algebra}}{An object of class \code{\link{MatrixLieAlgebra}} or \code{NULL}
representing the tangent space at the identity.}

\item{\code{n}}{The size of the \eqn{n \times n} matrix elements.}

\item{\code{left_canonical_metric}}{An object of class \code{InvariantMetric}
representing the left invariant metric that corresponds to the
Euclidean inner product at the identity.}

\item{\code{right_canonical_metric}}{An object of class \code{InvariantMetric}
representing the left invariant metric that corresponds to the
Euclidean inner product at the identity.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MatrixLieGroup-new}{\code{MatrixLieGroup$new()}}
\item \href{#method-MatrixLieGroup-exp}{\code{MatrixLieGroup$exp()}}
\item \href{#method-MatrixLieGroup-log}{\code{MatrixLieGroup$log()}}
\item \href{#method-MatrixLieGroup-get_identity}{\code{MatrixLieGroup$get_identity()}}
\item \href{#method-MatrixLieGroup-lie_bracket}{\code{MatrixLieGroup$lie_bracket()}}
\item \href{#method-MatrixLieGroup-tangent_translation_map}{\code{MatrixLieGroup$tangent_translation_map()}}
\item \href{#method-MatrixLieGroup-compose}{\code{MatrixLieGroup$compose()}}
\item \href{#method-MatrixLieGroup-inverse}{\code{MatrixLieGroup$inverse()}}
\item \href{#method-MatrixLieGroup-clone}{\code{MatrixLieGroup$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{MatrixLieGroup}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$new(dim, n, lie_algebra = NULL, ..., py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dim}}{An integer value specifying the dimension of the manifold.}

\item{\code{n}}{The size of the \eqn{n \times n} matrix elements.}

\item{\code{lie_algebra}}{An object of class \code{\link{MatrixLieAlgebra}} or \code{NULL}
representing the tangent space at the identity.}

\item{\code{...}}{Extra arguments to be passed to parent class constructors. See
\code{\link{Manifold}} class.}

\item{\code{py_cls}}{A Python object of class \code{MatrixLieGroup}. Defaults to
\code{NULL} in which case it is instantiated on the fly using the other
input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{MatrixLieGroup}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-exp"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-exp}{}}}
\subsection{Method \code{exp()}}{
Exponentiates a left-invariant vector field from a base
point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$exp(tangent_vec, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times n \times
  n]} specifying one or more tangent vectors at corresponding base
points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more base points on the manifold. Defaults to identity if
\code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The vector input is not an element of the Lie algebra, but of
the tangent space at \code{base_point}: if \eqn{g} denotes \code{base_point},
\eqn{v} the tangent vector, and \eqn{V = g^{-1} v} the associated Lie
algebra vector, then \deqn{\exp(v, g) = \mathrm{mul}(g, \exp(V))}.
Therefore, the Lie exponential is obtained when \code{base_point} is \code{NULL},
or the identity.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} storing
the left multiplication of the Lie exponential of the input tangent
vectors with the corresponding base points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  # so3$exp(diag(1, 3)) # TO DO: fix in gs
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-log"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-log}{}}}
\subsection{Method \code{log()}}{
Computes a left-invariant vector field bringing \code{base_point}
to \code{point}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$log(point, base_point = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more base points on the manifold. Defaults to identity if
\code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The output is a vector of the tangent space at \code{base_point}, so
not a Lie algebra element if \code{base_point} is not the identity.
Furthermore, denoting \code{point} by \eqn{g} and \code{base_point} by \eqn{h},
the output satisfies \deqn{g = \exp(\log(g, h), h)}.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} such
that its Lie exponential at corresponding base points matches
corresponding points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$log(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-get_identity"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-get_identity}{}}}
\subsection{Method \code{get_identity()}}{
Gets the identity of the group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$get_identity()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric array of shape \eqn{n \times n} storing the identity
of the Lie group.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$get_identity()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-lie_bracket"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-lie_bracket}{}}}
\subsection{Method \code{lie_bracket()}}{
Computes the lie bracket of two tangent vectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$lie_bracket(
  tangent_vector_a,
  tangent_vector_b,
  base_point = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vector_a}}{A numeric array of shape \eqn{[\dots \times n
  \times n]} specifying one or more tangent vectors at corresponding base
points.}

\item{\code{tangent_vector_b}}{A numeric array of shape \eqn{[\dots \times n
  \times n]} specifying one or more tangent vectors at corresponding base
points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more base points on the manifold. Defaults to identity if
\code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For matrix Lie groups with tangent vectors \eqn{A} and \eqn{B}
at the same base point \eqn{P}, this is given by (translate to
identity, compute commutator, go back): \deqn{[A,B] = A_P^{-1}B -
  B_P^{-1}A}.
}

\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} storing
the Lie bracket of the two input tangent vectors.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$lie_bracket(diag(0, 3), diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-tangent_translation_map"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-tangent_translation_map}{}}}
\subsection{Method \code{tangent_translation_map()}}{
Computes the push-forward map by the left/right translation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$tangent_translation_map(
  point,
  left_or_right = "left",
  inverse = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim},
  [n \times n] \} ]} specifying one or more points at which to compute
the map.}

\item{\code{left_or_right}}{A character string specifying whether to compute the
map for the left or right translation. Choices are \code{"left"} or
\verb{"right}. Defaults to \code{"left"}.}

\item{\code{inverse}}{A boolean specifying whether to inverse the Jacobian
matrix. If set to \code{TRUE}, the push forward by the translation by the
inverse of the point is returned. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Computes the push-forward map of the left/right translation by
the point. It corresponds to the tangent map, or differential of the
group multiplication by the point or its inverse. For groups with a
vector representation, it is only implemented at identity, but it can
be used at other points with \code{inverse = TRUE}. This method wraps the
Jacobian translation which actually computes the matrix representation
of the map.
}

\subsection{Returns}{
A function taking as argument a numeric array \code{tangent_vec} of
shape \eqn{[\dots \times \{ \mathrm{dim}, [n \times n] \} ]} specifying
one or more tangent vectors and returning a numeric array of shape
\eqn{[\dots \times \{ \mathrm{dim}, [n \times n] \} ]} storing the
result of the tangent mapping of the left/right translation of input
tangent points by corresponding base points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  tangent_map <- so3$tangent_translation_map(diag(1, 3))
  tangent_map(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-compose"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-compose}{}}}
\subsection{Method \code{compose()}}{
Performs function composition corresponding to the Lie
group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$compose(point_a, point_b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point_a}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, n \times n \}]} specifying one or more left factors in
the product.}

\item{\code{point_b}}{A numeric array of shape \eqn{[\dots \times \{
  \mathrm{dim}, n \times n \}]} specifying one or more right factors in
the product.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim}, n
  \times n \}]} storing the product of \code{point_a} and \code{point_b} along the
first dimension.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$compose(diag(1, 3), diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-inverse"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-inverse}{}}}
\subsection{Method \code{inverse()}}{
Computes the inverse law of the Lie group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$inverse(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times \{ \mathrm{dim},
n \times n \}]} specifying one or more points to be inverted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape storing the inverted points.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so3 <- SpecialOrthogonal(n = 3)
  so3$inverse(diag(1, 3))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixLieGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixLieGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixLieGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
