% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rid.R
\docType{package}
\name{rid}
\alias{rid}
\title{Random intervals distillation procedure}
\usage{
rid(
  data,
  M = 1000,
  l = 0,
  scaling = FALSE,
  q = 1,
  intervals = NULL,
  tau = c("clustering", "ref"),
  bw = "nrd0",
  adjust = 0.5,
  k.max = 4,
  adj = 1.3
)
}
\arguments{
\item{data}{A numeric matrix of observations with each horizontal axis being time, and each column being the multivariate time series}

\item{M}{A positive integer of random intervals, used only when \code{intervals=NULL}}

\item{l}{A non-negative integer of order of polynomial (\code{l=0} means piecewise constant)}

\item{scaling}{A logical scalar representing whether to perform refinement for locally stationary data. Only useful when \code{l=0}}

\item{q}{A positive integer of norm}

\item{intervals}{A numeric matrix of intervals with each row be a vector representing the interval. If \code{intervals=NULL}, random intervals are sampled}

\item{tau}{A non-negative number representing the threshold of detection. If \code{tau="clustering"} (only useful when \code{l=0}), a clustering-based adaptive approach is applied. If \code{tau="ref"}, a method based on simulated reference values is applied}

\item{bw}{A parameter passed into function \code{\link{density}}. Only useful when \code{tau="clustering"}}

\item{adjust}{A parameter passed into function \code{\link{density}}. Only useful when \code{tau="clustering"}}

\item{k.max}{A positive integer representing the maximum value of clusters in threshold determining. Only useful when \code{tau="clustering"}}

\item{adj}{A positive number used to multiply onto the threshold \code{tau}, providing threshold adjustments for small sample size}
}
\value{
A list containing:
\item{Good_Intervals}{A numeric matrix with each row being an interval that covers a change-point}
\item{Threshold}{A positive number of the threshold}
}
\description{
Distilled intervals that cover change-points are constructed.
}
\examples{
## An example for the univariate case
set.seed(0)
data=rep(c(0,2,0),each=40)+rnorm(120)
d=rid(data,M=1000,tau="clustering")
cpt=localization(data,d$Good_Intervals)
print(cpt)

## An example for the multivariate case
set.seed(0)
data1=rep(c(0,2,0),each=40)+rt(120,8)
data2=rep(c(0,2,0),each=40)+rnorm(120)
data=rbind(data1,data2)
d=rid(data,M=1000,tau="clustering")
cpt=localization(data,d$Good_Intervals)
print(cpt)

## An example for the piecewise polynomial case
set.seed(0)
n=300
cp=c(0,round(n/3),round(2*n/3),n)
mu=matrix(c(0.004,-0.1,0,-0.01,0.02,0,0.01,-0.04,0),nrow=3,byrow = TRUE)
mu1=mu[1,1]*(1:n)^2+mu[1,2]*(1:n)+mu[1,3]
for(j in 2:3){
 index=which((1:n)-cp[j]>0)
 tmp1=(1:n)-cp[j]
 tmp=mu[j,1]*tmp1^2+mu[j,2]*tmp1+mu[j,3]
 tmp[1:(index[1]-1)]=0
 mu1=mu1+tmp
}
data=mu1+runif(n,-6,6)
plot(data,type="l")
d=rid(data,M=500,tau="ref",l=2)
cpt=localization(data,d$Good_Intervals,l=2)
print(cpt)

## An example for refinement in the locally stationary time series
set.seed(0)
n=1000
cp=c(0,round(n/4),round(3*n/4),n)
epsilon=rnorm(500+n,0,1)
ei=rep(0,500+n)
for(j in 2:(500+n)){ei[j]=0.5*ei[j-1]+epsilon[j]}
x=ei[(501):(500+n)]
lrv=purrr::map_dbl(1:n,function(j){sqrt(max(1,2000*j/n))})
x=x*lrv
x=x+c(rep(0,round(n/4)),rep(20,round(n/2)),rep(-20,n-round(n/4)-round(n/2)))
data=x
plot(data,type="l")
d=rid(data,M=1000,scaling = TRUE,tau="clustering")
cpt=localization(data,d$Good_Intervals)
print(cpt)

}
\seealso{
{\code{\link{localization}}}
}
